/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.collection.iteration;

import icyllis.annotations.NotNull;
import icyllis.flexmark.util.collection.iteration.Indexed;
import icyllis.flexmark.util.collection.iteration.IndexedItemIterator;
import icyllis.flexmark.util.collection.iteration.ReversibleIndexedIterable;
import icyllis.flexmark.util.collection.iteration.ReversibleIndexedIterator;

public class IndexedItemIterable<R>
implements ReversibleIndexedIterable<R> {
    @NotNull
    private final Indexed<R> items;
    private final boolean reversed;

    public IndexedItemIterable(@NotNull Indexed<R> items) {
        this(items, false);
    }

    public IndexedItemIterable(@NotNull Indexed<R> items, boolean reversed) {
        this.items = items;
        this.reversed = reversed;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    @NotNull
    public ReversibleIndexedIterator<R> iterator() {
        return new IndexedItemIterator<R>(this.items, this.reversed);
    }

    @Override
    @NotNull
    public ReversibleIndexedIterable<R> reversed() {
        return new IndexedItemIterable<R>(this.items, !this.reversed);
    }

    @Override
    @NotNull
    public ReversibleIndexedIterator<R> reversedIterator() {
        return new IndexedItemIterator<R>(this.items, !this.reversed);
    }
}

